******************************************************************************************************************************************************************
******************************************** 1. Import raw survey data from Consensus Economics Excel files ******************************************************
******************************************************************************************************************************************************************

************************************************************ CF Region *******************************************************************************************
clear all
set more off
local counter = 1

foreach region in CF																						{				

			***Create local sheet variables for the different regions
			if "`region'"=="CF" 					{
				local sht `" "USA" "UK" "Canada" "Germany" "France" "Italy" "Netherlands" "Spain" "Norway" "Sweden" "'
			}
											
foreach sheet in `sht'	{

forvalues i = 1990(1)2021																				{
		
			if `i'<2021 					{
				local mnth `" "jan" "feb" "mar" "apr" "may" "jun" "jul" "aug" "sep" "oct" "nov" "dec" "'
			}
			else if `i'==2021				{
				local mnth `" "jan" "feb" "mar" "apr" "'
			}

foreach month in `mnth'				{ 						

import excel "\\boc-s2\adsp\Users\Home\sutc\MyDocs\Data and Software\CE\Raw Data/`region' `i' WB/`region'`month'`i'.xlsx", sheet(`sheet') clear
	
gen rowCounter = _n
keep if rowCounter >= 26
							
if "`month'"=="jan" | "`month'"=="feb" | "`month'"=="mar" | "`month'"=="apr" | "`month'"=="may"	| "`month'"=="jun"	| "`month'"=="jul"	| "`month'"=="aug"	| "`month'"=="sep"	| "`month'"=="oct"	| "`month'"=="nov"	| "`month'"=="dec"		{
gen monthnum = month(date("`month'","M"))
gen mdate = mofd(dofm(ym(`i', monthnum)))		
}
	
format %tm mdate
gen country = "`sheet'"
	
destring (C D M N X Y AD AE AF AG), ignore("na" "ma" "NA") replace

gen blankDelete = 1 if A == ""
drop if blankDelete == 1

* For the following macroeconomic variables, the following convention is used throughout the paper. 
* t: Current Year; t1: Next Year
rename A 	CE_Firm
rename C 	CE_GDP_t
rename D 	CE_GDP_t1
rename M 	CE_CPI_t
rename N 	CE_CPI_t1
* UR: Unemployment Rate
rename X 	CE_UR_t
rename Y 	CE_UR_t1
* For the following interest rate variables, the following convention is used throughout the paper.
* t: 3-month forecast horizon; t1: 12-month forecast horizon
rename AD 	CE_3M_t
rename AE 	CE_3M_t1
rename AF 	CE_10Y_t
rename AG 	CE_10Y_t1

keep 		CE_Firm CE_GDP_t CE_GDP_t1 CE_CPI_t CE_CPI_t1 CE_UR_t CE_UR_t1 CE_3M_t CE_3M_t1 CE_10Y_t CE_10Y_t1 mdate monthnum country
gen 		CountryFirm = country + CE_Firm

if `counter' > 1 {
append using 	"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_CF.dta"
					}
				
save 			"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_CF.dta", replace
local counter = `counter' + 1	
				
						}
					}
				}
			}

clear all
set more off
***Reminder: this list of CE firm mnemonics needs to be updated regularly.
import excel 	"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Data and Software\CE\All Mnemonics.xlsx", sheet("CF") cellrange(A1:B866) firstrow clear
merge m:m 		CountryFirm CountryFirm using "\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_CF.dta"

drop 			_merge CountryFirm
drop if Mnemonic==""
			
save 			"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_CF_merge.dta", replace


			
************************************************************ AP Region *******************************************************************************************		

clear all
set more off
local counter = 1

foreach region in AP																				{				

			***Create local sheet variables for the different regions
			if "`region'"=="AP" 					{
				local sht `" "Australia" "New Zealand" "'
			}
						
foreach sheet in `sht'	{

forvalues i = 1990(1)2021																				{

			if `i'<2021						{
				local mnth `" "jan" "feb" "mar" "apr" "may" "jun" "jul" "aug" "sep" "oct" "nov" "dec" "'
			}
			else if `i'==2021				{
				local mnth `" "jan" "feb" "mar" "apr" "'
			}

foreach month in `mnth'				{ 						


import excel "\\boc-s2\adsp\Users\Home\sutc\MyDocs\Data and Software\CE\Raw Data/`region' `i' WB/`region'`month'`i'.xlsx", sheet(`sheet') clear
	
gen rowCounter = _n
keep if rowCounter >= 26
						
if "`month'"=="jan" | "`month'"=="feb" | "`month'"=="mar" | "`month'"=="apr" | "`month'"=="may"	| "`month'"=="jun"	| "`month'"=="jul"	| "`month'"=="aug"	| "`month'"=="sep"	| "`month'"=="oct"	| "`month'"=="nov"	| "`month'"=="dec"		{
gen monthnum = month(date("`month'","M"))
gen mdate = mofd(dofm(ym(`i', monthnum)))		
}

format %tm mdate
gen country = "`sheet'"

destring (C D K L T U AH AI AJ AK), ignore("na" "ma" "NA") replace
*destring (C D K L T U AH AI AJ AK), ignore("na" "n.a." "ma" "NA" "N.A.") replace

gen blankDelete = 1 if A == ""
drop if blankDelete == 1

* t: Current Year; t1: Next Year:
rename A 	CE_Firm
rename C 	CE_GDP_t
rename D 	CE_GDP_t1
rename K 	CE_CPI_t
rename L 	CE_CPI_t1
* UR: Unemployment Rate:
rename T 	CE_UR_t
rename U 	CE_UR_t1
* t: 3-month forecast horizon; t1: 12-month forecast horizon:
rename AH 	CE_3M_t
rename AI 	CE_3M_t1
rename AJ 	CE_10Y_t
rename AK 	CE_10Y_t1

keep 		CE_Firm CE_GDP_t CE_GDP_t1 CE_CPI_t CE_CPI_t1 CE_UR_t CE_UR_t1 CE_3M_t CE_3M_t1 CE_10Y_t CE_10Y_t1 mdate monthnum country
gen 		CountryFirm = country + CE_Firm

if `counter' > 1 {
append using 	"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_AP.dta"
					}
				
save 			"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_AP.dta", replace
local counter = `counter' + 1	
				
						}
					}
				}
			}


clear all
set more off
import excel 	"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Data and Software\CE\All Mnemonics.xlsx", sheet("AP") cellrange(A1:B151) firstrow clear
merge m:m 		CountryFirm CountryFirm using "\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_AP.dta"

drop _merge CountryFirm
drop if Mnemonic==""
			
save 			"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_AP_merge.dta", replace



******************************************************************************************************************************************************************			
******************************************************* 2. APPEND ALL COUNTRIES **********************************************************************************		
******************************************************************************************************************************************************************

clear all 

use 			"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_CF_merge.dta"

append using 	"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_AP_merge.dta"

save 			"\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_Pooled Data.dta", replace

******************************************************************************************************************************************************************
******************************************************************************************************************************************************************
******************************************************************************************************************************************************************






******************************************************************************************************************************************************************
********************************* 3. MERGE CENTRAL BANK DATA SET (Main data set "Stata.." file) WITH CONSENSUS-ECONOMICS DATA (Above) **************************
******************************************************************************************************************************************************************

clear all
set more off
/// The ONLY place where the Excel file is used:
import excel "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE\Data and Empirical Analysis\Central Bank Communication Panel Data.xlsx", sheet("PANEL") cellrange(A4:BK5152) firstrow clear
gen double MONTH = monthly(M,"YM")
rename 	MONTH mdate
save "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE\Data and Empirical Analysis\FGandEF.dta", replace

clear all
set more off
use "\\boc-s2\adsp\Users\Home\sutc\MyDocs\Monetary Policy\Communication\Attention to Forward Guidance\Empirical Work\CE_import_m_i_Pooled Data.dta"

merge m:m 	mdate country using "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE\Data and Empirical Analysis\FGandEF.dta"
drop _merge

keep if country == "USA" | country == "UK" | country == "Canada" | country == "Australia" | country == "New Zealand" | country == "Norway" | country == "Sweden" | country == "Germany" | country == "France" | country == "Spain" | country == "Italy" | country == "Netherlands"
drop if Year > 2021
drop if Month_Code > 4 & Year == 2021

***Drop irrelevant vectors
drop			C1	C2	Quarter	Q	M	Month_Number	CE_Month	Key_M	Key_Q	Key_A	Key_BIS
drop			Data QE_Date	QE_Text	FG_Text

save  "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE\Data and Empirical Analysis\FGandEF.dta", replace

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////							
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////							






******************************************************************************************************************************************************************
***************************************************************** 4. Configure Data ******************************************************************************
******************************************************************************************************************************************************************

clear all
set more off
use "C:\Users\sutc\Desktop\Attention to Forward Guidance\JAE\Data and Empirical Analysis\FGandEF.dta"

*******************************************************************************************************************************************************	
***Set up variables and set data as panel data
drop if Mnemonic==""
encode Mnemonic , generate(firm)
global id firm
global t mdate
sort $id $t
xtset $id $t
*****Fix a naming convention that creates problems
replace country = "NewZealand" if strpos(country, "New Zealand") == 1
********************************************************************************************************************************************************

********************************************************************************************************************************************************
****Generate lagged values****
forvalues i = 1(1)1																			{
	bysort firm (mdate): 	g 	CE_CPI_t1_L`i'	=	CE_CPI_t1[_n-`i']
	bysort firm (mdate): 	g 	CE_GDP_t1_L`i'	=	CE_GDP_t1[_n-`i']
	bysort firm (mdate): 	g 	CE_UR_t1_L`i'	=	CE_UR_t1[_n-`i']
	}
********************************************************************************************************************************************************

****************************************************************************************************************************************************************************
******************************************* 4a. Calculate FIRST DIFFERENCES of forecasts ***********************************************************************************
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
****Current-year CE inflation first difference****
bysort firm (mdate): 	g 	CE_CPI_t_D1_M2_M12	=	D1.CE_CPI_t 								if monthnum>1
bysort firm (mdate): 	g 	CE_CPI_t_D1_M1		=	CE_CPI_t  		- 		CE_CPI_t1_L1		if monthnum==1
*******The x4 version of the series is used for regressions (so that a one unit change in the series can be interpreted as a 25 basis point change)
bysort firm (mdate): 	g 	CE_CPI_t_D1			=	(min(CE_CPI_t_D1_M2_M12,CE_CPI_t_D1_M1))
bysort firm (mdate): 	g 	CE_CPI_t_D1_x4		=	CE_CPI_t_D1*4
*******The bps version of the series is used for graphing the data
bysort firm (mdate): 	g 	CE_CPI_t_D1_bps		=	CE_CPI_t_D1_x4*25
drop 						CE_CPI_t_D1_M2_M12
drop 						CE_CPI_t_D1_M1
****Next-year CE inflation first difference****
bysort firm (mdate): 	g 	CE_CPI_t1_D1_M2_M12	=	(D1.CE_CPI_t1)*4 							if monthnum>1
bysort firm (mdate): 	g 	CE_CPI_t1_D1_M1		=	0				 							if monthnum==1
bysort firm (mdate): 	g 	CE_CPI_t1_D1_x4		=	(min(CE_CPI_t1_D1_M2_M12,CE_CPI_t1_D1_M1))*4
bysort firm (mdate): 	g 	CE_CPI_t1_D1_bps	=	CE_CPI_t1_D1_x4*25
drop 						CE_CPI_t1_D1_M2_M12
drop 						CE_CPI_t1_D1_M1
*****CE CPI first difference (weighted average)****
bysort firm (mdate): 	g 	CE_CPI_WA 			=	(((13-monthnum)/12)*CE_CPI_t) +	(((monthnum-1)/12)*CE_CPI_t1)
bysort firm (mdate): 	g 	CE_CPI_WA_x4		=	(CE_CPI_WA)*4
bysort firm (mdate): 	g 	CE_CPI_WA_bps		=	(CE_CPI_WA)*100
bysort firm (mdate): 	g 	CE_CPI_WA_D1_x4		=	(D1.CE_CPI_WA)*4
bysort firm (mdate): 	g 	CE_CPI_WA_D1_bps	=	(D1.CE_CPI_WA)*100
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
****Current-year CE domestic growth first difference****
bysort firm (mdate): 	g 	CE_GDP_t_D1_M2_M12	=	D1.CE_GDP_t 								if monthnum>1
bysort firm (mdate): 	g 	CE_GDP_t_D1_M1		=	CE_GDP_t  		- 		CE_GDP_t1_L1		if monthnum==1
bysort firm (mdate): 	g 	CE_GDP_t_D1_x4		=	(min(CE_GDP_t_D1_M2_M12,CE_GDP_t_D1_M1))*4
bysort firm (mdate): 	g 	CE_GDP_t_D1_bps		=	CE_GDP_t_D1_x4*25
drop 						CE_GDP_t_D1_M2_M12
drop 						CE_GDP_t_D1_M1
****Next-year CE domestic growth first difference****
bysort firm (mdate): 	g 	CE_GDP_t1_D1_M2_M12	=	(D1.CE_GDP_t1)*4 							if monthnum>1
bysort firm (mdate): 	g 	CE_GDP_t1_D1_M1		=	0				 							if monthnum==1
bysort firm (mdate): 	g 	CE_GDP_t1_D1_x4		=	(min(CE_GDP_t1_D1_M2_M12,CE_GDP_t1_D1_M1))*4
drop 						CE_GDP_t1_D1_M2_M12
drop 						CE_GDP_t1_D1_M1
*****CE GDP first difference (weighted average)****
bysort firm (mdate): 	g 	CE_GDP_WA 			=	(((13-monthnum)/12)*CE_GDP_t) +	(((monthnum-1)/12)*CE_GDP_t1)
bysort firm (mdate): 	g 	CE_GDP_WA_x4		=	(CE_GDP_WA)*4
bysort firm (mdate): 	g 	CE_GDP_WA_bps		=	(CE_GDP_WA)*100
bysort firm (mdate): 	g 	CE_GDP_WA_D1_x4		=	(D1.CE_GDP_WA)*4
bysort firm (mdate): 	g 	CE_GDP_WA_D1_bps	=	(D1.CE_GDP_WA)*100
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
*****Note: The Netherlands, Spain, Norway, and Sweden do not have unemployment forecast data
****Current-year CE unemployment first difference****
bysort firm (mdate): 	g 	CE_UR_t_D1_M2_M12	=	D1.CE_UR_t 								if monthnum>1
bysort firm (mdate): 	g 	CE_UR_t_D1_M1		=	CE_UR_t  		- 		CE_UR_t1_L1		if monthnum==1
bysort firm (mdate): 	g 	CE_UR_t_D1_x4		=	(min(CE_UR_t_D1_M2_M12,CE_UR_t_D1_M1))*4
bysort firm (mdate): 	g 	CE_UR_t_D1_bps		=	CE_UR_t_D1_x4*25
drop 						CE_UR_t_D1_M2_M12
drop 						CE_UR_t_D1_M1
****Next-year CE unemployment first difference****
bysort firm (mdate): 	g 	CE_UR_t1_D1_M2_M12	=	(D1.CE_UR_t1)*4 							if monthnum>1
bysort firm (mdate): 	g 	CE_UR_t1_D1_M1		=	0				 							if monthnum==1
bysort firm (mdate): 	g 	CE_UR_t1_D1_x4		=	(min(CE_UR_t1_D1_M2_M12,CE_UR_t1_D1_M1))*4
drop 						CE_UR_t1_D1_M2_M12
drop 						CE_UR_t1_D1_M1
*****CE UR first difference (weighted average)****
bysort firm (mdate): 	g 	CE_UR_WA 			=	(((13-monthnum)/12)*CE_UR_t) +	(((monthnum-1)/12)*CE_UR_t1)
bysort firm (mdate): 	g 	CE_UR_WA_x4			=	(CE_UR_WA)*4
bysort firm (mdate): 	g 	CE_UR_WA_bps		=	(CE_UR_WA)*100
bysort firm (mdate): 	g 	CE_UR_WA_D1_x4		=	(D1.CE_UR_WA)*4
bysort firm (mdate): 	g 	CE_UR_WA_D1_bps		=	(D1.CE_UR_WA)*100
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
****Current-year CENTRAL BANK inflation first difference****
bysort firm (mdate): 	g 	CB_CPI_t_D1_M2_M12	=	D1.CB_CPI_t 								if monthnum>1
bysort firm (mdate): 	g 	CB_CPI_t_D1_M1		=	CB_CPI_t  		- 		L.CB_CPI_t1			if monthnum==1
bysort firm (mdate): 	g 	CB_CPI_t_D1			=	min(CB_CPI_t_D1_M2_M12,CB_CPI_t_D1_M1)
bysort firm (mdate): 	g 	CB_CPI_t_D1_x4		=	CB_CPI_t_D1*4
bysort firm (mdate): 	g 	CB_CPI_t_D1_bps		=	CB_CPI_t_D1*100
drop 						CB_CPI_t_D1_M2_M12
drop 						CB_CPI_t_D1_M1
****Next-year CENTRAL BANK inflation first difference****
bysort firm (mdate): 	g 	CB_CPI_t1_D1_M2_M12	=	D1.CB_CPI_t1	 							if monthnum>1
bysort firm (mdate): 	g 	CB_CPI_t1_D1_M1		=	0				 							if monthnum==1
bysort firm (mdate): 	g 	CB_CPI_t1_D1		=	min(CB_CPI_t1_D1_M2_M12,CB_CPI_t1_D1_M1)
bysort firm (mdate): 	g 	CB_CPI_t1_D1_x4		=	CB_CPI_t1_D1*4
bysort firm (mdate): 	g 	CB_CPI_t1_D1_bps	=	CB_CPI_t1_D1*100
drop 						CB_CPI_t1_D1_M2_M12
drop 						CB_CPI_t1_D1_M1
*****CB CPI first difference (weighted average)****
bysort firm (mdate): 	g 	CB_CPI_WA 			=	(((13-monthnum)/12)*CB_CPI_t) +	(((monthnum-1)/12)*CB_CPI_t1)
bysort firm (mdate): 	g 	CB_CPI_WA_x4		=	(CB_CPI_WA)*4
bysort firm (mdate): 	g 	CB_CPI_WA_bps		=	(CB_CPI_WA)*100
bysort firm (mdate): 	g 	CB_CPI_WA_D1_x4		=	(D1.CB_CPI_WA)*4
bysort firm (mdate): 	g 	CB_CPI_WA_D1_bps	=	(D1.CB_CPI_WA)*100

****Current-year CENTRAL BANK GDP first difference****
bysort firm (mdate): 	g 	CB_GDP_t_D1_M2_M12	=	D1.CB_GDP_t 								if monthnum>1
bysort firm (mdate): 	g 	CB_GDP_t_D1_M1		=	CB_GDP_t  		- 		L.CB_GDP_t1			if monthnum==1
bysort firm (mdate): 	g 	CB_GDP_t_D1			=	min(CB_GDP_t_D1_M2_M12,CB_GDP_t_D1_M1)
bysort firm (mdate): 	g 	CB_GDP_t_D1_x4		=	CB_GDP_t_D1*4
bysort firm (mdate): 	g 	CB_GDP_t_D1_bps		=	CB_GDP_t_D1*100
drop 						CB_GDP_t_D1_M2_M12
drop 						CB_GDP_t_D1_M1
****Next-year CENTRAL BANK GDP first difference****
bysort firm (mdate): 	g 	CB_GDP_t1_D1_M2_M12	=	D1.CB_GDP_t1	 							if monthnum>1
bysort firm (mdate): 	g 	CB_GDP_t1_D1_M1		=	0				 							if monthnum==1
bysort firm (mdate): 	g 	CB_GDP_t1_D1		=	min(CB_GDP_t1_D1_M2_M12,CB_GDP_t1_D1_M1)
bysort firm (mdate): 	g 	CB_GDP_t1_D1_x4		=	CB_GDP_t1_D1*4
bysort firm (mdate): 	g 	CB_GDP_t1_D1_bps	=	CB_GDP_t1_D1*100
drop 						CB_GDP_t1_D1_M2_M12
drop 						CB_GDP_t1_D1_M1
*****CENTRAL BANK GDP first difference (weighted average)****
bysort firm (mdate): 	g 	CB_GDP_WA 			=	(((13-monthnum)/12)*CB_GDP_t) +	(((monthnum-1)/12)*CB_GDP_t1)
bysort firm (mdate): 	g 	CB_GDP_WA_x4		=	(CB_GDP_WA)*4
bysort firm (mdate): 	g 	CB_GDP_WA_bps		=	(CB_GDP_WA)*100
bysort firm (mdate): 	g 	CB_GDP_WA_D1_x4		=	(D1.CB_GDP_WA)*4
bysort firm (mdate): 	g 	CB_GDP_WA_D1_bps	=	(D1.CB_GDP_WA)*100

****Current-year CENTRAL BANK unemployment first difference****
bysort firm (mdate): 	g 	CB_UE_t_D1_M2_M12	=	D1.CB_UE_t 								if monthnum>1
bysort firm (mdate): 	g 	CB_UE_t_D1_M1		=	CB_UE_t  		- 		L.CB_UE_t1		if monthnum==1
bysort firm (mdate): 	g 	CB_UE_t_D1			=	min(CB_UE_t_D1_M2_M12,CB_UE_t_D1_M1)
bysort firm (mdate): 	g 	CB_UE_t_D1_x4		=	CB_UE_t_D1*4
bysort firm (mdate): 	g 	CB_UE_t_D1_bps		=	CB_UE_t_D1*100
drop 						CB_UE_t_D1_M2_M12
drop 						CB_UE_t_D1_M1
****Next-year CENTRAL BANK unemployment first difference****
bysort firm (mdate): 	g 	CB_UE_t1_D1_M2_M12	=	D1.CB_UE_t1	 							if monthnum>1
bysort firm (mdate): 	g 	CB_UE_t1_D1_M1		=	0				 						if monthnum==1
bysort firm (mdate): 	g 	CB_UE_t1_D1			=	min(CB_UE_t1_D1_M2_M12,CB_UE_t1_D1_M1)
bysort firm (mdate): 	g 	CB_UE_t1_D1_x4		=	CB_UE_t1_D1*4
bysort firm (mdate): 	g 	CB_UE_t1_D1_bps		=	CB_UE_t1_D1*100
drop 						CB_UE_t1_D1_M2_M12
drop 						CB_UE_t1_D1_M1
*****CB UE first difference (weighted average)****
bysort firm (mdate): 	g 	CB_UE_WA 			=	(((13-monthnum)/12)*CB_UE_t) +	(((monthnum-1)/12)*CB_UE_t1)
bysort firm (mdate): 	g 	CB_UE_WA_x4			=	(CB_UE_WA)*4
bysort firm (mdate): 	g 	CB_UE_WA_bps		=	(CB_UE_WA)*100
bysort firm (mdate): 	g 	CB_UE_WA_D1_x4		=	(D1.CB_UE_WA)*4
bysort firm (mdate): 	g 	CB_UE_WA_D1_bps		=	(D1.CB_UE_WA)*100

****Current-year CENTRAL BANK policy rate first difference****
bysort firm (mdate): 	g 	CB_PR_t_D1_M2_M12	=	D1.CB_PR_t 								if monthnum>1
bysort firm (mdate): 	g 	CB_PR_t_D1_M1		=	CB_PR_t  		- 		L.CB_PR_t1		if monthnum==1
bysort firm (mdate): 	g 	CB_PR_t_D1			=	min(CB_PR_t_D1_M2_M12,CB_PR_t_D1_M1)
bysort firm (mdate): 	g 	CB_PR_t_D1_x4		=	CB_PR_t_D1*4
bysort firm (mdate): 	g 	CB_PR_t_D1_bps		=	CB_PR_t_D1*100
drop 						CB_PR_t_D1_M2_M12
drop 						CB_PR_t_D1_M1
****Next-year CENTRAL BANK policy rate first difference****
bysort firm (mdate): 	g 	CB_PR_t1_D1_M2_M12	=	D1.CB_PR_t1	 							if monthnum>1
bysort firm (mdate): 	g 	CB_PR_t1_D1_M1		=	0				 						if monthnum==1
bysort firm (mdate): 	g 	CB_PR_t1_D1			=	min(CB_PR_t1_D1_M2_M12,CB_PR_t1_D1_M1)
bysort firm (mdate): 	g 	CB_PR_t1_D1_x4		=	CB_PR_t1_D1*4
bysort firm (mdate): 	g 	CB_PR_t1_D1_bps		=	CB_PR_t1_D1*100
drop 						CB_PR_t1_D1_M2_M12
drop 						CB_PR_t1_D1_M1
*****CB PR first difference (weighted average)****
bysort firm (mdate): 	g 	CB_PR_WA 			=	(((13-monthnum)/12)*CB_PR_t) +	(((monthnum-1)/12)*CB_PR_t1)
bysort firm (mdate): 	g 	CB_PR_WA_x4			=	(CB_PR_WA)*4
bysort firm (mdate): 	g 	CB_PR_WA_bps		=	(CB_PR_WA)*100
bysort firm (mdate): 	g 	CB_PR_WA_D1_x4		=	(D1.CB_PR_WA)*4
bysort firm (mdate): 	g 	CB_PR_WA_D1_bps		=	(D1.CB_PR_WA)*100

*For a robustness check, replace missing central bank projections values with zeros
bysort firm (mdate): 	g 	D_0					=	0
bysort firm (mdate): 	g 	CB_UE_WA_D1_x4_0s	=	(min(CB_UE_WA_D1_x4,D_0))
bysort firm (mdate): 	g 	CB_PR_WA_D1_x4_0s	=	(min(CB_PR_WA_D1_x4,D_0))
bysort firm (mdate): 	g 	CB_CPI_WA_D1_x4_0s	=	(min(CB_CPI_WA_D1_x4,D_0))
bysort firm (mdate): 	g 	CB_GDP_WA_D1_x4_0s	=	(min(CB_GDP_WA_D1_x4,D_0))
bysort firm (mdate): 	g 	CE_UR_WA_D1_x4_0s	=	(min(CE_UR_WA_D1_x4,D_0))
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
****Calculate first differences of CE rates forecasts (much simpler because these are fixed-horizon forecasts and not fixed-event forecasts like inflation and output forecasts are)****
bysort firm (mdate): 	g 	CE_3M_t_D1_bps		=	(D1.CE_3M_t)*100
bysort firm (mdate): 	g 	CE_3M_t1_D1_bps		=	(D1.CE_3M_t1)*100
bysort firm (mdate): 	g 	CE_3M_t_D1_x4		=	(D1.CE_3M_t)*4
bysort firm (mdate): 	g 	CE_3M_t1_D1_x4		=	(D1.CE_3M_t1)*4
bysort firm (mdate): 	g 	CE_10Y_t_D1_bps		=	(D1.CE_10Y_t)*100
bysort firm (mdate): 	g 	CE_10Y_t1_D1_bps	=	(D1.CE_10Y_t1)*100
bysort firm (mdate): 	g 	CE_10Y_t_D1_x4		=	(D1.CE_10Y_t)*4
bysort firm (mdate): 	g 	CE_10Y_t1_D1_x4		=	(D1.CE_10Y_t1)*4
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
******************************************* 4b. Calculate SUMMARY STATISTICS of forecasts ***************************************************************************************
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
*** 4bi. Convert some key rates variables into BASIS POINTS (useful for graphing and empirical work on disagreement)
*CE
bysort mdate country: 	gen 	CE_3M_t_bps			=	CE_3M_t*100
bysort mdate country: 	gen 	CE_3M_t1_bps		=	CE_3M_t1*100
bysort mdate country: 	gen 	CE_10Y_t_bps		=	CE_10Y_t*100
bysort mdate country: 	gen 	CE_10Y_t1_bps		=	CE_10Y_t1*100
bysort mdate country: 	gen 	CE_CPI_t_bps		=	CE_CPI_t*100
bysort mdate country: 	gen 	CE_CPI_t1_bps		=	CE_CPI_t1*100
bysort mdate country: 	gen 	CE_GDP_t_bps		=	CE_GDP_t*100
bysort mdate country: 	gen 	CE_GDP_t1_bps		=	CE_GDP_t1*100
bysort mdate country: 	gen 	CE_UR_t_bps			=	CE_UR_t*100
bysort mdate country: 	gen 	CE_UR_t1_bps		=	CE_UR_t1*100
*PR
bysort firm (mdate): 	gen 	PR_bps				=	PR*100
bysort firm (mdate): 	gen 	PR_D1_x4			=	(D1.PR)*4
bysort firm (mdate): 	gen 	PR_D1_bps			=	(D1.PR)*100
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
*********** 4bii. Calculate CE MEAN FORECASTS (averaged across forecaster within country within month)********
bysort mdate country: 	egen 	CE_3M_t_bps_mean	=	mean(CE_3M_t_bps)
bysort mdate country: 	egen 	CE_3M_t1_bps_mean	=	mean(CE_3M_t1_bps)
bysort mdate country: 	egen 	CE_10Y_t_bps_mean	=	mean(CE_10Y_t_bps)
bysort mdate country: 	egen 	CE_10Y_t1_bps_mean	=	mean(CE_10Y_t1_bps)
bysort mdate country: 	egen 	CE_CPI_t_bps_mean	=	mean(CE_CPI_t_bps)
bysort mdate country: 	egen 	CE_CPI_t1_bps_mean	=	mean(CE_CPI_t1_bps)
bysort mdate country: 	egen 	CE_CPI_WA_bps_mean	=	mean(CE_CPI_WA_bps)
bysort mdate country: 	egen 	CE_GDP_t_bps_mean	=	mean(CE_GDP_t_bps)
bysort mdate country: 	egen 	CE_GDP_t1_bps_mean	=	mean(CE_GDP_t1_bps)
bysort mdate country: 	egen 	CE_GDP_WA_bps_mean	=	mean(CE_GDP_WA_bps)

*********** 4biii. Calculate CE MEAN forecast REVISIONS (averaged across forecaster within country within month)********
bysort mdate country: 	egen 	CE_3M_t_D1_bps_mean		=	mean(CE_3M_t_D1_bps)
bysort mdate country: 	egen 	CE_3M_t1_D1_bps_mean	=	mean(CE_3M_t1_D1_bps)
bysort mdate country: 	egen 	CE_10Y_t_D1_bps_mean	=	mean(CE_10Y_t_D1_bps)
bysort mdate country: 	egen 	CE_10Y_t1_D1_bps_mean	=	mean(CE_10Y_t1_D1_bps)
bysort mdate country: 	egen 	CE_CPI_WA_D1_bps_mean	=	mean(CE_CPI_WA_D1_bps)
bysort mdate country: 	egen 	CE_GDP_WA_D1_bps_mean	=	mean(CE_GDP_WA_D1_bps)
bysort mdate country: 	egen 	CE_UR_WA_D1_bps_mean	=	mean(CE_UR_WA_D1_bps)
bysort mdate country: 	egen 	CE_CPI_WA_D1_x4_mean	=	mean(CE_CPI_WA_D1_x4)
bysort mdate country: 	egen 	CE_GDP_WA_D1_x4_mean	=	mean(CE_GDP_WA_D1_x4)
bysort mdate country: 	egen 	CE_UR_WA_D1_x4_mean		=	mean(CE_UR_WA_D1_x4)
*********** 4biv.  Calculate CE forecast STANDARD DEVIATION (SD) (across forecaster within country within month)********
bysort mdate country: 	egen 	CE_3M_t_bps_sd			=	sd(CE_3M_t_bps)
bysort mdate country: 	egen 	CE_3M_t1_bps_sd			=	sd(CE_3M_t1_bps)
bysort mdate country: 	egen 	CE_10Y_t_bps_sd			=	sd(CE_10Y_t_bps)
bysort mdate country: 	egen 	CE_10Y_t1_bps_sd		=	sd(CE_10Y_t1_bps)
bysort mdate country: 	egen 	CE_CPI_WA_x4_sd			=	sd(CE_CPI_WA_x4)
bysort mdate country: 	egen 	CE_GDP_WA_x4_sd			=	sd(CE_GDP_WA_x4)
bysort mdate country: 	egen 	CE_UR_WA_x4_sd			=	sd(CE_UR_WA_x4)
*********** 4biv-1.  Create LAGS CE forecast STANDARD DEVIATION (SD) (Interaction terms; Stata 15 does not allow the use of lag operators within interaction terms)
bysort firm (mdate): 	g 		CE_3M_t_bps_sd_L1		=	L.CE_3M_t_bps_sd
bysort firm (mdate): 	g 		CE_3M_t1_bps_sd_L1		=	L.CE_3M_t1_bps_sd
bysort firm (mdate): 	g 		CE_10Y_t_bps_sd_L1		=	L.CE_10Y_t_bps_sd
bysort firm (mdate): 	g 		CE_10Y_t1_bps_sd_L1		=	L.CE_10Y_t1_bps_sd
bysort firm (mdate): 	g 		CE_CPI_WA_x4_sd_L1		=	L.CE_CPI_WA_x4_sd
bysort firm (mdate): 	g 		CE_GDP_WA_x4_sd_L1		=	L.CE_GDP_WA_x4_sd
bysort firm (mdate): 	g 		CE_UR_WA_x4_sd_L1		=	L.CE_UR_WA_x4_sd
*********** 4biv-2.  STANDARDIZE (STD) CE forecast STANDARD DEVIATION (SD) ********
egen							CE_3M_t_bps_sd_std		=	std(CE_3M_t_bps_sd)
egen							CE_3M_t1_bps_sd_std		=	std(CE_3M_t1_bps_sd)
egen							CE_10Y_t_bps_sd_std		=	std(CE_10Y_t_bps_sd)
egen							CE_10Y_t1_bps_sd_std	=	std(CE_10Y_t1_bps_sd)
egen							CE_CPI_WA_x4_sd_std		=	std(CE_CPI_WA_x4_sd)
egen							CE_GDP_WA_x4_sd_std		=	std(CE_GDP_WA_x4_sd)
egen							CE_UR_WA_x4_sd_std		=	std(CE_UR_WA_x4_sd)
*********** 4biv-3.  Create LAGS of STD CE forecast SD (Interaction terms; Stata 15 does not allow the use of lag operators within interaction terms)
bysort firm (mdate): 	g	 	CE_3M_t_bps_sd_std_L1	=	L.CE_3M_t_bps_sd_std
bysort firm (mdate): 	g	 	CE_3M_t1_bps_sd_std_L1	=	L.CE_3M_t1_bps_sd_std
bysort firm (mdate): 	g	 	CE_10Y_t_bps_sd_std_L1	=	L.CE_10Y_t_bps_sd_std
bysort firm (mdate): 	g	 	CE_10Y_t1_bps_sd_std_L1	=	L.CE_10Y_t1_bps_sd_std
bysort firm (mdate): 	g	 	CE_CPI_WA_x4_sd_std_L1	=	L.CE_CPI_WA_x4_sd_std
bysort firm (mdate): 	g	 	CE_GDP_WA_x4_sd_std_L1	=	L.CE_GDP_WA_x4_sd_std
bysort firm (mdate): 	g	 	CE_UR_WA_x4_sd_std_L1	=	L.CE_UR_WA_x4_sd_std
*********** 4bv-1.  Calculate CE forecast REVISION Standard Deviation (SD) (across forecaster within country within month)********
bysort mdate country: 	egen 	CE_3M_t1_D1_bps_sd		=	sd(CE_3M_t1_D1_bps)
bysort mdate country: 	egen 	CE_CPI_WA_D1_x4_sd		=	sd(CE_CPI_WA_D1_x4)
bysort mdate country: 	egen 	CE_GDP_WA_D1_x4_sd		=	sd(CE_GDP_WA_D1_x4)
*********** 4bv-2.  Create LAGS (REVISION) to be used in the interaction terms (Stata 15 does not allow the use of lag operators within interaction terms)
bysort firm (mdate): 	g 		CE_3M_t1_D1_bps_sd_L1	=	L.CE_3M_t1_D1_bps_sd
bysort firm (mdate): 	g 		CE_CPI_WA_D1_x4_sd_L1	=	L.CE_CPI_WA_D1_x4_sd
bysort firm (mdate): 	g 		CE_GDP_WA_D1_x4_sd_L1	=	L.CE_GDP_WA_D1_x4_sd
*********** 4bv-3.  STANDARDIZE CE forecast REVISION Standard Deviation BY FORECASTER********
bysort firm (mdate): 	egen 	CE_3M_t1_bps_sd_mean	=	mean(CE_3M_t1_bps_sd)
bysort firm (mdate):	egen 	CE_3M_t1_bps_sd_sd		=	sd(CE_3M_t1_bps_sd)
bysort firm (mdate):	g	 	CE_3M_t1_bps_sd_std2	=	(CE_3M_t1_bps_sd - CE_3M_t1_bps_sd_mean) / CE_3M_t1_bps_sd_sd
bysort firm (mdate): 	g	 	CE_3M_t1_bps_sd_std2_L1	=	L.CE_3M_t1_bps_sd_std2
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
******************************************* 4c. Calculate AD-HOC variables ***************************************************************************************
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
**** 4ci. Calculate RATE PATHS
************The three-month treasury bill rate path: this tells you how much forecasters expect the three-month treasury bill rate to rise or fall during the forecast horizon that spans from four months into the future until 12 months into the future.
bysort firm (mdate): 	g 	CE_3M_path_bps			=	(CE_3M_t1			-		CE_3M_t)*100
************The ten-year treasury bond yield path: this tells you how much forecasters expect the ten-year treasury yield rate to rise or fall during the forecast horizon that spans from four months into the future until 12 months into the future.
bysort firm (mdate): 	g 	CE_10Y_path_bps			=	(CE_10Y_t1			-		CE_10Y_t)*100
************The slope of the yield curve in three months: this tells you what forecasters expect the slope of the yield curve to be (the difference between the 10-year government bond yield and the three-month treasury bill rate) to be in twelve months' time.
bysort firm (mdate): 	g 	CE_slope_t_bps			=	(CE_10Y_t			-		CE_3M_t)*100
************The slope of the yield curve in twelve months: this tells you what forecasters expect the slope of the yield curve to be (the difference between the 10-year government bond yield and the three-month treasury bill rate) to be in twelve months' time.
bysort firm (mdate): 	g 	CE_slope_t1_bps			=	(CE_10Y_t1			-		CE_3M_t1)*100
****Calculate the first differences in the variables described above
bysort firm (mdate): 	g 	CE_3M_path_D1_bps		=	CE_3M_t1_D1_bps		-		CE_3M_t_D1_bps
bysort firm (mdate): 	g 	CE_10Y_path_D1_bps		=	CE_10Y_t1_D1_bps	-		CE_10Y_t_D1_bps
bysort firm (mdate): 	g 	CE_slope_t_D1_bps		=	CE_10Y_t_D1_bps		-		CE_3M_t_D1_bps
bysort firm (mdate): 	g 	CE_slope_t1_D1_bps		=	CE_10Y_t1_D1_bps	-		CE_3M_t1_D1_bps
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
*** 4cii. Generate ABSOLUTE VALUE for select variables****
bysort firm (mdate): 	g 	FG_Change_abs			=	abs(FG_Change)
bysort firm (mdate): 	g 	FG_ODYSSEAN_abs 		= 	abs(FG_ODYSSEAN)
bysort firm (mdate): 	g 	FG_DELPHIC_abs	 		= 	abs(FG_DELPHIC)
bysort firm (mdate): 	g 	FG_Q_abs				=	abs(FG_Q)
bysort firm (mdate): 	g 	FG_TC_abs				=	abs(FG_TC)
bysort firm (mdate): 	g 	FG_SC_abs				=	abs(FG_SC)
bysort firm (mdate): 	g 	FG_abs					=	abs(FG)
bysort firm (mdate): 	g 	QE_Change_abs			=	abs(QE_Change)
***
bysort firm (mdate): 	g 	CE_3M_t1_D1_abs			=	abs(CE_3M_t1_D1_bps)
bysort firm (mdate): 	g 	CE_CPI_WA_D1_x4_abs		=	abs(CE_CPI_WA_D1_x4)
bysort firm (mdate): 	g 	CE_GDP_WA_D1_x4_abs		=	abs(CE_GDP_WA_D1_x4)
bysort firm (mdate): 	g 	CE_UR_WA_D1_x4_abs		=	abs(CE_UR_WA_D1_x4)
***
bysort firm (mdate): 	g 	CB_CPI_WA_D1_x4_abs		=	abs(CB_CPI_WA_D1_x4)
bysort firm (mdate): 	g 	CB_GDP_WA_D1_x4_abs		=	abs(CB_GDP_WA_D1_x4)

bysort firm (mdate): 	g 	CE_CPI_WA_D1_dummy		=	0
replace						CE_CPI_WA_D1_dummy		=	1	if CE_CPI_WA_D1_x4_abs > 0.2
***
bysort firm (mdate): 	g   PR_D1_x4_abs			=	abs(PR_D1_x4)
bysort firm (mdate): 	g   PR_D1_dummy				=	0
replace						PR_D1_dummy				=	1	if PR_D1_x4_abs	> 0.25
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
*** 4ciii. Generate Interaction Terms for country-by-country analysis****
bysort firm (mdate): 	g 	FG_Ch_x_PR_D1_x4_abs	=	FG_Change * PR_D1_x4_abs
bysort firm (mdate): 	g 	FG_Ch_x_QE_Ch_abs		=	FG_Change * QE_Change_abs
bysort firm (mdate): 	g 	FG_Ch_x_ELB				=	FG_Change * ELB
bysort firm (mdate): 	g 	FG_Ch_x_FG_Odys_abs		=	FG_Change * FG_ODYSSEAN_abs
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
*** 4civ. SPILLOVERS work
***Generate Fed-only global forward guidance variables***
bysort firm (mdate): 			g FG_Change_Fed			= FG_Change if country=="USA"
bysort mdate (FG_Change_Fed): 	replace FG_Change_Fed	= FG_Change_Fed[1]
bysort firm (mdate): 			replace FG_Change_Fed	= 0 if country=="USA" | FG_Change_Fed==.
*****Generate ECB-only global forward guidance variables***
bysort firm (mdate): 			g FG_Change_ECB			= FG_Change if country=="France"
bysort mdate (FG_Change_ECB): 	replace FG_Change_ECB 	= FG_Change_ECB[1]
bysort firm (mdate): 			replace FG_Change_ECB	= 0 if country=="France" | country=="Germany" | country=="Netherlands" | country=="Spain" | country=="Italy" | FG_Change_ECB==. 
***Generate Bank of England-only global forward guidance variables***
bysort firm (mdate): 			g FG_Change_BOE			= FG_Change if country=="UK"
bysort mdate (FG_Change_BOE): 	replace FG_Change_BOE	= FG_Change_BOE[1]
bysort firm (mdate): 			replace FG_Change_BOE	= 0 if country=="UK" | FG_Change_BOE==.
***Generate Bank of Canada-only global forward guidance variables***
bysort firm (mdate): 			g FG_Change_BOC			= FG_Change if country=="Canada"
bysort mdate (FG_Change_BOC): 	replace FG_Change_BOC	= FG_Change_BOC[1]
bysort firm (mdate): 			replace FG_Change_BOC	= 0 if country=="Canada" | FG_Change_BOC==.
***Generate RBNZ-only global forward guidance variables***
bysort firm (mdate): 			g FG_Change_RBNZ		= FG_Change if country=="NewZealand"
bysort mdate (FG_Change_RBNZ): 	replace FG_Change_RBNZ	= FG_Change_RBNZ[1]
bysort firm (mdate): 			replace FG_Change_RBNZ	= 0 if country=="NewZealand" | FG_Change_RBNZ==. 
***Generate RBA-only global forward guidance variables***
bysort firm (mdate): 			g FG_Change_RBA			= FG_Change if country=="Australia"
bysort mdate (FG_Change_RBA): 	replace FG_Change_RBA	= FG_Change_RBA[1]
bysort firm (mdate): 			replace FG_Change_RBA	= 0 if country=="Australia" | FG_Change_RBA==.
***Generate NB-only global forward guidance variables***
bysort firm (mdate): 			g FG_Change_NB			= FG_Change if country=="Norway"
bysort mdate (FG_Change_NB): 	replace FG_Change_NB	= FG_Change_NB[1]
bysort firm (mdate): 			replace FG_Change_NB	= 0 if country=="Norway" | FG_Change_NB==.
***Generate SR-only global forward guidance variables***
bysort firm (mdate): 			g FG_Change_SR			= FG_Change if country=="Sweden"
bysort mdate (FG_Change_SR): 	replace FG_Change_SR	= FG_Change_SR[1]
bysort firm (mdate): 			replace FG_Change_SR	= 0 if country=="Sweden" | FG_Change_SR==.
***Generate Fed-only global QE variables***
bysort firm (mdate): 			g QE_Change_Fed			= QE_Change if country=="USA"
bysort mdate (QE_Change_Fed): 	replace QE_Change_Fed	= QE_Change_Fed[1]
bysort firm (mdate): 			replace QE_Change_Fed	= 0 if country=="USA" | QE_Change_Fed==.
****************************************************************************************************************************************************************************

****************************************************************************************************************************************************************************
*** 4cv. Split forward guidance change variables into hawkish and dovish changes
bysort firm (mdate): 	g 	FG_Change_H	= 1			if  FG_Change==1
replace FG_Change_H = 0 if missing(FG_Change_H)
bysort firm (mdate): 	g 	FG_Change_D	= -1		if  FG_Change==-1
replace FG_Change_D = 0 if missing(FG_Change_D)
****************************************************************************************************************************************************************************


****************************************************************************************************************************************************************************
*********************************************************** 5. DATA CLEANING ***********************************************************************************************
****************************************************************************************************************************************************************************

******Note: the results are robust to not performing these data cleaning steps below, but they are done as a best practice
bysort firm : 			gen MonthGap = D1.mdate
****Remove errors: only keep the data for which continuity exists (this aligns the charted data with the regression data; these observations get dropped in regressions because there is no first difference)
drop if D1.mdate>1
***Now redundant: remove errors: drop the first instance of a firm's data because it cannot provide a first difference (in fact, that first difference is erroneous because it is the difference between forecasts by two different firms into very different periods)
****** This was used in past versions of the paper. [This CE_Firm adjustment removes a lot of errors! Do not remove.]
*bysort firm (mdate): 	g 	CE_Firm_L1		=	CE_Firm[_n-1]
*drop if CE_Firm!=CE_Firm_L1
***Now redundant: remove errors: drop the first instance of a Mnemonic's data because it should not provide a first difference 
*bysort firm (mdate): 	g 	Mnemonic_L1		=	Mnemonic[_n-1]
*drop if Mnemonic!=Mnemonic_L1

****Keep the data for which a full relevant information set exists (keep the gaps between forecasts to one month)
*******(this also allows the graphs to map to the empirical work; otherwise, graphs would display data that is automatically dropped in regressions)
*******This filtering is done based on the forecast variables in the benchmark regressions
bysort firm (mdate): 	drop if CE_3M_t1_D1_bps==.
bysort firm (mdate): 	drop if FG_Change==.
bysort firm (mdate): 	drop if PR_D1_x4==.
bysort firm (mdate): 	drop if CE_CPI_WA_D1_x4==.
bysort firm (mdate): 	drop if CE_GDP_WA_D1_x4==.
bysort firm (mdate): 	drop if QE_Change==.
bysort firm (mdate): 	drop if ELB==.
****************************************************************************************************************************************************************************

*******Drop any clusters that were not around for at least 30 months as (i) they may be coding errors (ii) it is doubtful how credible a forecaster may be if that firm was only in the sample for less than a year (i.e., perhaps they did not take data submission seriously, for example)
*******This does not have any meaningful effect on the results but should ease the reader's mind that results are not driven by small individual forecaster sample sizes.
bysort firm : gen T = _N
drop if T<30
egen group = group(firm)
su group, meanonly

****************************************************************************************************************************************************************************
***********Variables that allowed me to test for date-based anomalies and queries
g 			ln_monthnum		=	ln(monthnum)
*g 			ln_yearnum		=	ln((Year-1989))
tabulate 	monthnum, 			generate(dmonthnum)
*tabulate 	firm, 			generate(dfirm)
egen 		double_cluster	=	group(firm country)
*gen edateFG = date(FG_Date,"DMY")
*bysort mdate : gen t = _n
****************************************************************************************************************************************************************************


save 			"C:\Users\sutc\Desktop\Attention to Forward Guidance\FGandEF.dta", replace
